﻿//////////////////////////////////////////////
// TestStackLevel.h
// 
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkDebug
#include "../../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Containers/BufferCast.h>
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------

namespace nkDebug
{
	class DLL_NKDEBUG_EXPORT TestStackLevel final
	{
		public :

			// Constructors
			TestStackLevel () noexcept ;
			TestStackLevel (nkMemory::StringView functionName, unsigned int line) noexcept ;

			// Getters
			nkMemory::StringView getFunctionName () const ;
			unsigned int getLine () const ;

			// Setters
			void setFunctionName (nkMemory::StringView value) ;
			void setLine (unsigned int value) ;

		private :

			// Attributes
			nkMemory::String _functionName ;
			unsigned int _line = 0u ;
	} ;
}